
A network-based malware protection device **gives a security analyst a means** to detect the **movement of files** in the network and to **take appropriate action**.

Malware continues to evolve along with the tools used to detect and eradicate it. 
Cyber criminals design and test malware against the very tools that organizations might use to detect threats such as **Snort** (tool to detect threat).

**Network-based malware** protection **acts on files** that are **traversing the network**. This distinction is important when compared to endpoint malware protection, which is the more traditional variety in which endpoints (hosts) run protection software locally.

Network-based malware protection **prevents malware files from being transmitted** through the network. This protection mechanism is employed in many security devices such as a **Cisco Secure Firewall, Cisco Secure Email, Cisco Secure Web Appliance, and Cisco Umbrella/Cloudlock**.


**Using Network-Based malware protection:** 

Policy Configuration
- Allows selection of file types to monitor over commonly used protocols.
- Sends Secure Hash Algorithm 256 (SHA-256) hashes, metadata, or copies of files to the cloud for analysis.


Cloud Analysis and File Disposition
- **Clean Disposition**: Returned if the file hash is known and no threats are associated.
- **Malware Disposition**: Given if the cloud analysis indicates the file is malicious.
- **Unknown Disposition**: Returned if the file hash has not been seen before.

Handling Unknown Files
- Files with an unknown disposition are automatically submitted for dynamic analysis.
- Not all file types are supported for dynamic analysis submission.

Sandboxing and Analysis
- The cloud runs files in a sandboxing test environment for analysis.
- Results are returned to the management console within minutes.
- If sandboxing fails to reach a firm conclusion, the file’s disposition remains unknown.

Further Actions for Unknown Files
- May require manual reverse engineering to determine if the file is malicious.

**Example**: 
The following figure shows a sample event from the Cisco Secure Firewall Threat Defense device, which also provides network-based malware protection.
![[Pasted image 20250304175210.png]]


**Quiz**: 
Which statement describes how a network-based malware protection feature detects a possible event?

- Using virus signature files locally on the firewall, it will detect incorrect MD5 file hashes.
    
- The firewall applies broad-based application and file control policies to detect malware. (**Correct**)
    
- Malware can be detected correctly by using reputation databases on both the firewall and/or from the cloud.
    
- IDS signature files that are located on the firewall are used to detect the presence of malware.
    
- Malware can be detected and stopped by using ACLs and the modular policy framework within the firewall appliance.


**Quiz**: 

In the dynamic landscape of cybersecurity, network-based malware protection plays a pivotal role. Imagine a scenario where a company's network security system has flagged a suspicious file with an "unknown" disposition. Despite the initial uncertainty, the file undergoes thorough cloud-based analysis and is eventually deemed malicious. What crucial feature of network-based malware protection ensures that this newfound threat is communicated and acted upon across the network?


Immediate File Deletion Protocol: Automatically deletes files with unknown dispositions until proven safe.

Real-time Threat Sharing Mechanism: Instantly shares the malicious file's details with all connected endpoints.

Retrospective Event Notification: Updates the management console with the new file disposition and adjusts previous event records.

Proactive Sandbox Isolation: Isolates the suspicious file in a virtual environment, preventing immediate network access.

**Correct Answer:**

Retrospective Event Notification

**Reason**:

The retrospective event notification is a key feature of network-based malware protection systems that allows for the continuous updating of a file's disposition. When a file initially flagged as "unknown" is later determined to be malicious, this feature ensures that all previous interactions and events associated with the file are updated in the management console. This allows security administrators to retroactively understand the impact of the threat, adjust their security measures accordingly, and prevent further spread across the network.

